
****************************************************************** 
********************** ANALYSIS ********************** 
****************************************************************** 
  
insheet using "mp_daily.csv", clear names

g year = substr(date,1,4)
g month = substr(date,6,2)
g day = substr(date,9,2)

destring year month day, replace

*****************
*IMPORTANT
drop if year < 2001
*Imposing this because NSI data are less reliable before this time 
*****************

gen d=mdy(month,day,year)
format %td d

g id = 1
tsset id d

merge 1:1 d using "crate_1980_2020.dta", nogen keep(match master)



*Board meetings...
merge 1:1 d using "board_meetings.dta", nogen keep(match master)

replace board = 0 if board == .


gen dow = dow( mdy(month, day, year))


*Z scores
egen nsi_mean = mean(nsi)
egen nsi_sd = sd(nsi)
g znsi = (nsi-nsi_mean)/nsi_sd

*Window of 14 days around policy announcement 
tsset id d
g window = 0 if board ==1
replace window = 1 if l1.board == 1
replace window = 2 if l2.board == 1
replace window = 3 if l3.board == 1
replace window = 4 if l4.board == 1
replace window = 5 if l5.board == 1
replace window = 6 if l6.board == 1
replace window = 7 if l7.board == 1
replace window = 8 if l8.board == 1
replace window = 9 if l9.board == 1
replace window = 10 if l10.board == 1
replace window = 11 if l11.board == 1
replace window = 12 if l12.board == 1
replace window = 13 if l13.board == 1
replace window = 14 if l14.board == 1


replace window = -1 if f1.board == 1
replace window = -2 if f2.board == 1
replace window = -3 if f3.board == 1
replace window = -4 if f4.board == 1
replace window = -5 if f5.board == 1
replace window = -6 if f6.board == 1
replace window = -7 if f7.board == 1
replace window = -8 if f8.board == 1
replace window = -9 if f9.board == 1
replace window = -10 if f10.board == 1
replace window = -11 if f11.board == 1
replace window = -12 if f12.board == 1
replace window = -13 if f13.board == 1
replace window = -14 if f14.board == 1

g period = (window ~=.)


*KEY VARIABLES...
tsset id d

*3-day MA 
g nsi_ma = (nsi+l1.nsi+l2.nsi)/3
g znsi_ma = (znsi+l1.znsi+l2.znsi)/3



*Setting baseline 
*THIS IS VERY IMPORTANT
*The baseline definitely should not update with the horizon 
*This sets the baseline as the 3-day MA on the day before the announcement 


g pnsi = nsi_ma  if window == -1 
g pznsi = znsi_ma  if window == -1 


foreach i in pnsi pznsi {
replace `i' = l1.`i' if window == 0
replace `i'= l1.`i' if window == 1
replace `i'= l1.`i' if window == 2
replace `i'= l1.`i' if window == 3
replace `i'= l1.`i' if window == 4
replace `i'= l1.`i' if window == 5
replace `i'= l1.`i' if window == 6
replace `i'= l1.`i' if window == 7
replace `i'= l1.`i' if window == 8
replace `i'= l1.`i' if window == 9
replace `i'= l1.`i' if window == 10
replace `i'= l1.`i' if window == 11
replace `i'= l1.`i' if window == 12
replace `i'= l1.`i' if window == 13
replace `i'= l1.`i' if window == 14
}


tsset id d

*Estimates the changes over each horizon 
forvalues i = 0/14{
qui g dznsi`i' = f`i'.znsi - pznsi 
}

*THIS IS IMPORTANT!!!
*Want to restrict the sample to 14 days within the day of the Board meeting
*Otherwise more than double counting some horizons 
keep if window == 0

keep year month dznsi* day 
reshape long dznsi, i(year month day) j(horizon)
drop if dznsi == .


*MP shocks...
merge m:1 month year using "mpshocks.dta", nogen keep(match master)

*OIS shocks
merge m:1 day month year using "ois_shocks.dta", nogen keep(match master)
bysort month year: egen ois1m = mean(ois_1m)


*Run through each type of shock one at a time in same framework 
*I currently pull in the estimated coefficients from the regression into a s/sheet
*I then manually calculate the smooth LPs by multiplying coefficients by the horizon 

***********************
*BECKERS SHOCKS 
***********************

preserve 
drop if btcs ==.
g shock = btcs
g horizonsq = horizon*horizon 
g zero = (horizon == 0)
g nonzero = (horizon > 0)
g zshock = zero*shock 
g nzshock = shock*nonzero 
g nzshock_h = nzshock*horizon
g nzshock_h2 = nzshock*horizonsq

reg dznsi zshock nzshock nzshock_h nzshock_h2 
bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2

*The standard errors are bootstrapped 
*Note the change to the method for calculating degrees of freedom here

qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 1, atmeans at(zshock = 1 nzshock = 0 nzshock_h = 0 nzshock_h2 = 0) post 
g yhat0 = _b[_cons]
g ci10_h0 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h0 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 1, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 1 nzshock_h2 = 1) post 
g yhat1 = _b[_cons]
g ci10_h1 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h1 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 2, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 2 nzshock_h2 = 4) post 
g yhat2 = _b[_cons]
g ci10_h2 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h2 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]

qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 3, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 3 nzshock_h2 = 9) post 
g yhat3 = _b[_cons]
g ci10_h3 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h3 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 4, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 4 nzshock_h2 = 16) post 
g yhat4 = _b[_cons]
g ci10_h4 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h4 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 5, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 5 nzshock_h2 = 25) post 
g yhat5 = _b[_cons]
g ci10_h5 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h5 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 6, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 6 nzshock_h2 = 36) post 
g yhat6 = _b[_cons]
g ci10_h6 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h6 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 7, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 7 nzshock_h2 = 49) post 
g yhat7 = _b[_cons]
g ci10_h7 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h7 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 8, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 8 nzshock_h2 = 64) post 
g yhat8 = _b[_cons]
g ci10_h8 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h8 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 9, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 9 nzshock_h2 = 81) post 
g yhat9 = _b[_cons]
g ci10_h9 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h9 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 10, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 10 nzshock_h2 = 100) post 
g yhat10 = _b[_cons]
g ci10_h10 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h10 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


collapse(mean) yhat* ci* , by(horizon)
drop horizon  
keep in 1 
g id = 1 
reshape long yhat ci10_h ci90_h, i(id) j(horizon)

outsheet using "nsi_beckers_smooth.csv", comma replace
restore

*************************
*BISHOP AND TULIP SHOCKS
*************************
preserve 
drop if bishop ==.
g shock = bishop
g horizonsq = horizon*horizon 
g zero = (horizon == 0)
g nonzero = (horizon > 0)
g zshock = zero*shock 
g nzshock = shock*nonzero 
g nzshock_h = nzshock*horizon
g nzshock_h2 = nzshock*horizonsq

reg dznsi zshock nzshock nzshock_h nzshock_h2 


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 1, atmeans at(zshock = 1 nzshock = 0 nzshock_h = 0 nzshock_h2 = 0) post 
g yhat0 = _b[_cons]
g ci10_h0 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h0 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 1, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 1 nzshock_h2 = 1) post 
g yhat1 = _b[_cons]
g ci10_h1 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h1 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 2, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 2 nzshock_h2 = 4) post 
g yhat2 = _b[_cons]
g ci10_h2 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h2 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]

qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 3, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 3 nzshock_h2 = 9) post 
g yhat3 = _b[_cons]
g ci10_h3 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h3 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 4, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 4 nzshock_h2 = 16) post 
g yhat4 = _b[_cons]
g ci10_h4 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h4 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 5, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 5 nzshock_h2 = 25) post 
g yhat5 = _b[_cons]
g ci10_h5 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h5 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 6, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 6 nzshock_h2 = 36) post 
g yhat6 = _b[_cons]
g ci10_h6 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h6 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 7, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 7 nzshock_h2 = 49) post 
g yhat7 = _b[_cons]
g ci10_h7 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h7 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 8, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 8 nzshock_h2 = 64) post 
g yhat8 = _b[_cons]
g ci10_h8 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h8 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 9, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 9 nzshock_h2 = 81) post 
g yhat9 = _b[_cons]
g ci10_h9 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h9 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 10, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 10 nzshock_h2 = 100) post 
g yhat10 = _b[_cons]
g ci10_h10 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h10 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]

collapse(mean) yhat* ci* , by(horizon)
drop horizon  

keep in 1 
g id = 1 
reshape long yhat ci10_h ci90_h, i(id) j(horizon)

outsheet using "nsi_bishop_smooth.csv", comma replace
restore

**********************
*1-MONTH OIS SHOCKS 
**********************
preserve 
drop if ois1m ==.
g shock = ois1m
g horizonsq = horizon*horizon 
g zero = (horizon == 0)
g nonzero = (horizon > 0)
g zshock = zero*shock 
g nzshock = shock*nonzero 
g nzshock_h = nzshock*horizon
g nzshock_h2 = nzshock*horizonsq

reg dznsi zshock nzshock nzshock_h nzshock_h2 


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 1, atmeans at(zshock = 1 nzshock = 0 nzshock_h = 0 nzshock_h2 = 0) post 
g yhat0 = _b[_cons]
g ci10_h0 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h0 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 1, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 1 nzshock_h2 = 1) post 
g yhat1 = _b[_cons]
g ci10_h1 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h1 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 2, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 2 nzshock_h2 = 4) post 
g yhat2 = _b[_cons]
g ci10_h2 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h2 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]

qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 3, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 3 nzshock_h2 = 9) post 
g yhat3 = _b[_cons]
g ci10_h3 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h3 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 4, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 4 nzshock_h2 = 16) post 
g yhat4 = _b[_cons]
g ci10_h4 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h4 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 5, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 5 nzshock_h2 = 25) post 
g yhat5 = _b[_cons]
g ci10_h5 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h5 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 6, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 6 nzshock_h2 = 36) post 
g yhat6 = _b[_cons]
g ci10_h6 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h6 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 7, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 7 nzshock_h2 = 49) post 
g yhat7 = _b[_cons]
g ci10_h7 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h7 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 8, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 8 nzshock_h2 = 64) post 
g yhat8 = _b[_cons]
g ci10_h8 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h8 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 9, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 9 nzshock_h2 = 81) post 
g yhat9 = _b[_cons]
g ci10_h9 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h9 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 10, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 10 nzshock_h2 = 100) post 
g yhat10 = _b[_cons]
g ci10_h10 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h10 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]

collapse(mean) yhat* ci* , by(horizon)
drop horizon  
 
keep in 1 
g id = 1 
reshape long yhat ci10_h ci90_h, i(id) j(horizon)

outsheet using "nsi_ois1m_smooth.csv", comma replace
restore


preserve 
drop if cratechange ==.
g shock = cratechange
g horizonsq = horizon*horizon 
g zero = (horizon == 0)
g nonzero = (horizon > 0)
g zshock = zero*shock 
g nzshock = shock*nonzero 
g nzshock_h = nzshock*horizon
g nzshock_h2 = nzshock*horizonsq

reg dznsi zshock nzshock nzshock_h nzshock_h2 


g yhat = _b[zshock]*zero + _b[nzshock]*nonzero + _b[nzshock_h]*horizon + _b[nzshock_h2]*horizon*horizon + _b[_cons]

qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 1, atmeans at(zshock = 1 nzshock = 0 nzshock_h = 0 nzshock_h2 = 0) post 
g yhat0 = _b[_cons]
g ci10_h0 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h0 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 1, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 1 nzshock_h2 = 1) post 
g yhat1 = _b[_cons]
g ci10_h1 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h1 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 2, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 2 nzshock_h2 = 4) post 
g yhat2 = _b[_cons]
g ci10_h2 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h2 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]

qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 3, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 3 nzshock_h2 = 9) post 
g yhat3 = _b[_cons]
g ci10_h3 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h3 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 4, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 4 nzshock_h2 = 16) post 
g yhat4 = _b[_cons]
g ci10_h4 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h4 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 5, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 5 nzshock_h2 = 25) post 
g yhat5 = _b[_cons]
g ci10_h5 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h5 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 6, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 6 nzshock_h2 = 36) post 
g yhat6 = _b[_cons]
g ci10_h6 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h6 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 7, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 7 nzshock_h2 = 49) post 
g yhat7 = _b[_cons]
g ci10_h7 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h7 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 8, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 8 nzshock_h2 = 64) post 
g yhat8 = _b[_cons]
g ci10_h8 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h8 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 9, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 9 nzshock_h2 = 81) post 
g yhat9 = _b[_cons]
g ci10_h9 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h9 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]


qui bootstrap, reps(100) seed(1): reg dznsi zshock nzshock nzshock_h nzshock_h2, level(90)
margins if horizon == 10, atmeans at(zshock = 0 nzshock = 1 nzshock_h = 10 nzshock_h2 = 100) post 
g yhat10 = _b[_cons]
g ci10_h10 = _b[_cons] - invttail(e(N)-5,0.05) * _se[_cons]
g ci90_h10 = _b[_cons] + invttail(e(N)-5,0.05) * _se[_cons]

collapse(mean) yhat* ci* , by(horizon)
drop yhat horizon  

keep in 1 
g id = 1 
reshape long yhat ci10_h ci90_h, i(id) j(horizon)

outsheet using "nsi_crate_smooth.csv", comma replace

restore
